
//************************************************************
// SHADER FILE FOR HH3 VENDETTA MAP
// Shaders written by Charlie Zimmerman and Scampie
// Supplied for Quake3Arena Mod Headhunters at 
// http://tarot.telefragged.com
// Textures by Rorshach.

//************************************************************

//************************************************************
// 4_met_sh01 shader
// - The 1134 texture with fire showing through.  Casts light.
//************************************************************

textures/q3hh4/4_met_sh01_fire
{
  // The image to be used by q3radiant
  qer_editorimage textures/q3hh4/4_met_sh01.tga
  // light comes from the other tga
  q3map_lightimage textures/q3hh4/4_met_sh02.tga
  // has some light to it.
  q3map_surfacelight 750
  // cant shoot it
  surfaceparm nomarks
	light 1
	{
		map $lightmap
		rgbGen identity
	}
  //surfaceparm projectionShadow
  // Start with the fire swirl in the frame buffer.
  {
     map textures/q3hh4/4_met_sh02.tga
     tcmod scale 4 4
     tcMod rotate 180
     //tcMod Scroll 0.01 0.05
     tcMod turb 0 .25 0 .6
     rgbGen identity
     alphaGen lightingSpecular
  }
  // Now place decal of the framework skin over it
  {
     map textures/q3hh4/4_met_sh01.tga
     blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
     rgbGen identity
  }
}

//************************************************************
// 4_met_sh01_grate shader
// - The 1134 texture with fire showing through.  Does not cast
//   light but does cast alphashadow when light source placed 
//   behind it.
//************************************************************

textures/q3hh4/4_met_sh01_grate
{
  // The image to be used by q3radiant
  qer_editorimage textures/q3hh4/4_met_sh01.tga
  // cant shoot it
  surfaceparm nomarks
  surfaceparm alphashadow
	light 1
	{
		map $lightmap
		rgbGen identity
	}
  // Start with the fire swirl in the frame buffer.
  {
     map textures/q3hh4/4_met_sh02.tga
     tcmod scale 4 4
     tcMod rotate 180
     //tcMod Scroll 0.01 0.05
     tcMod turb 0 .25 0 .6
     rgbGen identity
     alphaGen lightingSpecular
  }
  // Now place decal of the framework skin over it
  {
     map textures/q3hh4/4_met_sh01.tga
     blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
     rgbGen identity
  }
}

//************************************************************
// 4_met_sh02_fire shader
// - Swirling fire shader.  Casts light.  Put behind the 
//   grate texture to cause the alpha shadow.
//************************************************************

textures/q3hh4/4_met_sh02_fire
{
  // The image to be used by q3radiant
  qer_editorimage textures/q3hh4/4_met_sh02.tga
  // has some light to it.
  q3map_surfacelight 4000
  // cant shoot it
  surfaceparm nomarks
	light 1
	{
		map $lightmap
		rgbGen identity
	}
  // Start with the fire swirl in the frame buffer.
  {
     map textures/q3hh4/4_met_sh02.tga
     tcmod scale 4 4
     tcMod rotate 180
     //tcMod Scroll 0.01 0.05
     tcMod turb 0 .25 0 .6
     rgbGen identity
     alphaGen lightingSpecular
  }
}



textures/q3hh4/4_light01_5000
{
  // The image to be used by q3radiant
  qer_editorimage textures/q3hh4/4_light01.tga
	q3map_lightimage textures/q3hh4/4_light01.tga
	surfaceparm nomarks
	q3map_surfacelight 5000
	light 1
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/q3hh4/4_light01.tga
		blendFunc filter
		rgbGen identity
	}
      {
		map textures/q3hh4/4_light01.tga
		blendFunc add
	}
}

textures/q3hh4/4_light01_5000_blink
{
  // The image to be used by q3radiant
  qer_editorimage textures/q3hh4/4_light01.tga
	q3map_lightimage textures/q3hh4/4_light01_blend.tga
	surfaceparm nomarks
	q3map_surfacelight 5000
	light 1
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/q3hh4/4_light01.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
      {
		map textures/q3hh4/4_light01_blend.tga
	      rgbGen wave sin 0.5 0.5 0 4
		blendfunc GL_ONE GL_ONE
	}
}

textures/q3hh4/4_light01a_5000
{
  // The image to be used by q3radiant
  qer_editorimage textures/q3hh4/4_light01a.tga
	q3map_lightimage textures/q3hh4/4_light01a.tga
	surfaceparm nomarks
	q3map_surfacelight 5000
	light 1
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/q3hh4/4_light01a.tga
		blendFunc filter
		rgbGen identity
	}
      {
		map textures/q3hh4/4_light01a.tga
		blendFunc add
	}
}

textures/q3hh4/4_light01b_10000
{
  // The image to be used by q3radiant
  qer_editorimage textures/q3hh4/4_light01b.tga
	q3map_lightimage textures/q3hh4/4_light01b.tga
	surfaceparm nomarks
	q3map_surfacelight 10000
	light 1
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/q3hh4/4_light01b.tga
		blendFunc filter
		rgbGen identity
	}
      {
		map textures/q3hh4/4_light01b.tga
		blendFunc add
	}
}

textures/q3hh4/4_light02_5000
{
  // The image to be used by q3radiant
  qer_editorimage textures/q3hh4/4_light02.tga
	q3map_lightimage textures/q3hh4/4_light02.tga
	surfaceparm nomarks
	q3map_surfacelight 5000
	light 1
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/q3hh4/4_light02.tga
		blendFunc filter
		rgbGen identity
	}
      {
		map textures/q3hh4/4_light02.tga
		blendFunc add
	}
}

textures/q3hh4/4_light02_2000
{
  // The image to be used by q3radiant
  qer_editorimage textures/q3hh4/4_light02.tga
	q3map_lightimage textures/q3hh4/4_light02.tga
	surfaceparm nomarks
	q3map_surfacelight 2000
	light 1
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/q3hh4/4_light02.tga
		blendFunc filter
		rgbGen identity
	}
      {
		map textures/q3hh4/4_light02.tga
		blendFunc add
	}
}

textures/q3hh4/4_light02a_5000
{
  // The image to be used by q3radiant
  qer_editorimage textures/q3hh4/4_light02a.tga
	q3map_lightimage textures/q3hh4/4_light02a.tga
	surfaceparm nomarks
	q3map_surfacelight 5000
	light 1
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/q3hh4/4_light02a.tga
		blendFunc filter
		rgbGen identity
	}
      {
		map textures/q3hh4/4_light02a.tga
		blendFunc add
	}
}

textures/q3hh4/4_light02b_10000
{
  // The image to be used by q3radiant
  qer_editorimage textures/q3hh4/4_light02b.tga
	q3map_lightimage textures/q3hh4/4_light02b.tga
	surfaceparm nomarks
	q3map_surfacelight 10000
	light 1
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/q3hh4/4_light02b.tga
		blendFunc filter
		rgbGen identity
	}
      {
		map textures/q3hh4/4_light02b.tga
		blendFunc add
	}
}

textures/q3hh4/4_trimllight01_10000
{
  // The image to be used by q3radiant
  qer_editorimage textures/q3hh4/4_trimllight01.tga
	q3map_lightimage textures/q3hh4/4_trimllight01.tga
	surfaceparm nomarks
	q3map_surfacelight 10000
	light 1
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/q3hh4/4_trimllight01.tga
		blendFunc filter
		rgbGen identity
	}
      {
		map textures/q3hh4/4_trimllight01.tga
		blendFunc add
	}
}

textures/q3hh4/4_trimllight01_5000
{
  // The image to be used by q3radiant
  qer_editorimage textures/q3hh4/4_trimllight01.tga
	q3map_lightimage textures/q3hh4/4_trimllight01.tga
	surfaceparm nomarks
	q3map_surfacelight 5000
	light 1
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/q3hh4/4_trimllight01.tga
		blendFunc filter
		rgbGen identity
	}
      {
		map textures/q3hh4/4_trimllight01.tga
		blendFunc add
	}
}

textures/q3hh4/4_trimllight01_1000
{
  // The image to be used by q3radiant
  qer_editorimage textures/q3hh4/4_trimllight01.tga
	q3map_lightimage textures/q3hh4/4_trimllight01.tga
	surfaceparm nomarks
	q3map_surfacelight 1000
	light 1
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/q3hh4/4_trimllight01.tga
		blendFunc filter
		rgbGen identity
	}
      {
		map textures/q3hh4/4_trimllight01.tga
		blendFunc add
	}
}

textures/q3hh4/4_met04b_1000
{
  // The image to be used by q3radiant
  qer_editorimage textures/q3hh4/4_met04b.tga
	q3map_lightimage textures/q3hh4/4_met04b.tga
	surfaceparm nomarks
	q3map_surfacelight 1000
	light 1
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/q3hh4/4_met04b.tga
		blendFunc filter
	}
      {
		map textures/q3hh4/4_met04b.tga
		blendFunc add
	}
}

textures/q3hh4/4_met04t_1000
{
  // The image to be used by q3radiant
  qer_editorimage textures/q3hh4/4_met04t.tga
	q3map_lightimage textures/q3hh4/4_met04t.tga
	surfaceparm nomarks
	q3map_surfacelight 1000
	light 1
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/q3hh4/4_met04t.tga
		blendFunc filter
	}
      {
		map textures/q3hh4/4_met04t.tga
		blendFunc add
	}
}
textures/q3hh4/4_bouncer01
{
	{	
		map $lightmap
		rgb identity
	}
	{
		map textures/q3hh1/goldshine4.tga
		tcmod scale 1 1
		tcmod rotate 54
	}
	{
		map textures/q3hh4/4_bouncer01.tga
		blendfunc GL_ONE GL_SRC_ALPHA
	}
}
textures/q3hh4/4_metwl02
{
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/q3hh4/4_met_sh02.tga
		tcmod scale 2 2 
		tcmod rotate 45
		tcMod Scroll 0.1 0.5
     		tcMod turb 0 .25 0 .6
	}
	{
		map textures/q3hh4/4_metwl02.tga
		blendfunc GL_ONE GL_SRC_ALPHA
	}
}

textures/q3hh4/4_met05b_1000
{
  // The image to be used by q3radiant
  qer_editorimage textures/q3hh4/4_met05b.tga
	q3map_lightimage textures/q3hh4/4_met05b.tga
	surfaceparm nomarks
	q3map_surfacelight 3500
	light 1
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/q3hh4/4_met05b.tga
		blendFunc filter
	}
      {
		map textures/q3hh4/4_met05b.tga
		blendFunc add
	}
}

textures/q3hh4/4_trimllight_sm_10000
{
  // The image to be used by q3radiant
  qer_editorimage textures/q3hh4/4_trimllight01.tga
	q3map_lightimage textures/q3hh4/4_trimllight01.tga
	surfaceparm nomarks
	q3map_surfacelight 10000
	light 1
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/q3hh4/4_trimllight01.tga
		tcmod scale 2 2
		blendFunc filter
		rgbGen identity
	}
        {
		map textures/q3hh4/4_trimllight01.tga
		tcmod scale 2 2
		blendFunc add
	}
}

textures/q3hh4/4_trimllight_sm_5000
{
  // The image to be used by q3radiant
  qer_editorimage textures/q3hh4/4_trimllight01.tga
	q3map_lightimage textures/q3hh4/4_trimllight01.tga
	surfaceparm nomarks
	q3map_surfacelight 5000
	light 1
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/q3hh4/4_trimllight01.tga
		tcmod scale 2 2
		blendFunc filter
		rgbGen identity
	}
        {
		map textures/q3hh4/4_trimllight01.tga
		tcmod scale 2 2
		blendFunc add
	}
}

textures/q3hh4/4_trimllight_sm_1000
{
  // The image to be used by q3radiant
  qer_editorimage textures/q3hh4/4_trimllight01.tga
	q3map_lightimage textures/q3hh4/4_trimllight01.tga
	surfaceparm nomarks
	q3map_surfacelight 1000
	light 1
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/q3hh4/4_trimllight01.tga
		tcmod scale 2 2
		blendFunc filter
		rgbGen identity
	}
      {
		map textures/q3hh4/4_trimllight01.tga
		tcmod scale 2 2
		blendFunc add
	}
}

textures/q3hh4/4_met05b_2000
{
  // The image to be used by q3radiant
  qer_editorimage textures/q3hh4/4_met05b.tga
	q3map_lightimage textures/q3hh4/4_met05b.tga
	surfaceparm nomarks
	q3map_surfacelight 2000
	light 1
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/q3hh4/4_met05b.tga
		blendFunc filter
	}
      {
		map textures/q3hh4/4_met05b.tga
		blendFunc add
	}
}
