const uint DELAY = 40;

const double PI = 3.14159265359;

uint[] teleported(maxClients);

Vec3 rotateX(Vec3 v, float a)
{
	return Vec3(
		v.x,
		v.y*cos(a)-v.z*sin(a),
		v.y*sin(a)+v.z*cos(a)
	);
}

Vec3 rotateY(Vec3 v, float a)
{
	return Vec3(
		v.x*cos(a)+v.z*sin(a),
		v.y,
		-v.x*sin(a)+v.z*cos(a)
	);
}

Vec3 rotateZ(Vec3 v, float a)
{
	return Vec3(
		cos(a)*v.x - sin(a)*v.y,
		sin(a)*v.x + cos(a)*v.y,
		v.z
	);
}

void target_hettoo( Entity @ent )
{
    @ent.use = target_hettoo_use;
}

Vec3 getAngles( Entity @h )
{
    array<Entity@>@ targets = h.findTargets();
    for ( uint i = 0; i < targets.length(); i++ )
    {
        Entity@ target = targets[i];
        if ( target.classname == "target_position" )
        {
            return target.origin;
        }
    }
    return Vec3();
}

void target_hettoo_use( Entity @ent, Entity @other, Entity @activator )
{
    if ( levelTime < teleported[activator.client.playerNum] + DELAY )
        return;

    array<Entity@>@ targets = ent.findTargets();
    for ( uint i = 0; i < targets.length(); i++ )
    {
        Entity@ target = targets[i];
        if ( target.classname == "target_hettoo" )
        {
            Vec3 currentAngles = getAngles( ent );
            Vec3 vel = activator.velocity;
            vel.z = 0;
            if ( vel.length() == 0 )
                return;
            Vec3 vangles = vel.toAngles();
            double diff = abs( vangles.y - currentAngles.z * 180.0 / PI );
            while ( diff > 180 )
                diff -= 360;
            if ( abs( diff ) < 90 )
            {
                Vec3 origin_difference = activator.origin - ent.origin;
                Vec3 angle_adjust = getAngles(target) - currentAngles;
                Vec3 origin = target.origin;
                Vec3 mins, maxs;
                activator.getSize( mins, maxs );
                origin.z -= mins.z;
                origin_difference = rotateZ( origin_difference, angle_adjust.z );
                origin_difference = rotateY( origin_difference, angle_adjust.y );
                origin_difference = rotateX( origin_difference, angle_adjust.x );
                origin = origin + origin_difference;
                origin.z += mins.z;
                activator.origin = origin;
                activator.angles = Vec3(activator.angles.x, activator.angles.y + angle_adjust.z * 180.0 / PI, activator.angles.z);

                vangles.y += angle_adjust.z * 180.0 / PI;
                Vec3 rotated_vel, bla1, bla2;
                vangles.angleVectors( rotated_vel, bla1, bla2 );
                rotated_vel.normalize();
                float speed = vel.length();
                activator.velocity = Vec3( rotated_vel.x * speed, rotated_vel.y * speed, activator.velocity.z );

                teleported[activator.client.playerNum] = levelTime;
                return;
            }
        }
    }
}
